/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.registration;

import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_3414;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import slimeknights.mantle.registration.deferred.BlockDeferredRegister;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.world.block.BuddingCrystalBlock;
import slimeknights.tconstruct.world.block.CrystalBlock;
import slimeknights.tconstruct.world.block.CrystalClusterBlock;

public class GeodeItemObject
extends ItemObject<class_1792> {
    private final Supplier<? extends class_2248> block;
    private final Supplier<? extends class_2248> budding;
    private final Supplier<? extends class_2248> cluster;
    private final Supplier<? extends class_2248> smallBud;
    private final Supplier<? extends class_2248> mediumBud;
    private final Supplier<? extends class_2248> largeBud;

    public GeodeItemObject(RegistryObject<? extends class_1792> shard, BlockDeferredRegister register, class_3620 color, class_2498 blockSound, class_3414 chimeSound, Map<BudSize, class_2498> clusterSounds, int baseLight, class_1792.class_1793 props) {
        super(shard);
        IntFunction<ToIntFunction> light = extra -> {
            int calculated = Math.min(extra + baseLight, 15);
            return state -> calculated;
        };
        String name = shard.getId().method_12832();
        Function<class_2248, class_1747> blockItem = block -> new class_1747(block, props);
        ToIntFunction crystalLight = light.apply(0);
        this.block = register.register(name + "_block", () -> new CrystalBlock(chimeSound, class_4970.class_2251.method_9637().method_31710(color).method_9631(crystalLight).method_9632(1.5f).method_9626(blockSound).method_29292()), blockItem);
        this.budding = register.register("budding_" + name, () -> new BuddingCrystalBlock(this, chimeSound, class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_31710(color).method_9640().method_9631(crystalLight).method_9632(1.5f).method_9626(blockSound).method_29292()), blockItem);
        Supplier<class_4970.class_2251> budProps = () -> class_4970.class_2251.method_9637().method_31710(color).method_22488().method_9632(1.5f);
        this.cluster = register.register(name + "_cluster", () -> new CrystalClusterBlock(chimeSound, 7, 3, ((class_4970.class_2251)budProps.get()).method_9631((ToIntFunction)light.apply(5)).method_9626((class_2498)clusterSounds.get((Object)BudSize.CLUSTER))), blockItem);
        this.smallBud = register.register("small_" + name + "_bud", () -> new CrystalClusterBlock(chimeSound, 3, 3, ((class_4970.class_2251)budProps.get()).method_9631((ToIntFunction)light.apply(1)).method_9626((class_2498)clusterSounds.get((Object)BudSize.SMALL))), blockItem);
        this.mediumBud = register.register("medium_" + name + "_bud", () -> new CrystalClusterBlock(chimeSound, 4, 3, ((class_4970.class_2251)budProps.get()).method_9631((ToIntFunction)light.apply(2)).method_9626((class_2498)clusterSounds.get((Object)BudSize.MEDIUM))), blockItem);
        this.largeBud = register.register("large_" + name + "_bud", () -> new CrystalClusterBlock(chimeSound, 5, 3, ((class_4970.class_2251)budProps.get()).method_9631((ToIntFunction)light.apply(4)).method_9626((class_2498)clusterSounds.get((Object)BudSize.LARGE))), blockItem);
    }

    public class_2248 getBlock() {
        return this.block.get();
    }

    public class_2248 getBudding() {
        return this.budding.get();
    }

    public class_2248 getBud(BudSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case BudSize.SMALL -> this.smallBud.get();
            case BudSize.MEDIUM -> this.mediumBud.get();
            case BudSize.LARGE -> this.largeBud.get();
            case BudSize.CLUSTER -> this.cluster.get();
        };
    }

    public static enum BudSize {
        SMALL,
        MEDIUM,
        LARGE,
        CLUSTER;

        public static final BudSize[] SIZES;
        private final String name = this.name().toLowerCase(Locale.ROOT);
        private final int size = this.ordinal() + 1;

        public BudSize getNext() {
            return switch (this) {
                case SMALL -> MEDIUM;
                case MEDIUM -> LARGE;
                case LARGE -> CLUSTER;
                default -> SMALL;
            };
        }

        public String getName() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }

        static {
            SIZES = new BudSize[]{SMALL, MEDIUM, LARGE};
        }
    }
}

